/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import jclass.table3.Clip;
import jclass.table3.JCCell;
import jclass.table3.JCCellPosition;
import jclass.table3.JCCellRange;
import jclass.table3.Size;
import jclass.table3.SpanList;
import jclass.table3.Table;
import jclass.util.JCVector;

class Span
implements Serializable {
    private Table table;
    JCVector span_list = new JCVector();
    JCVector span_list_orig = new JCVector();

    Span(Table table) {
        this.table = table;
    }

    int find(int n, int n2, JCCellPosition jCCellPosition) {
        JCCellRange jCCellRange = new JCCellRange();
        int n3 = this.find(n, n2, jCCellRange, null);
        if (n3 != -999 && jCCellPosition != null) {
            jCCellPosition.row = jCCellRange.start_row;
            jCCellPosition.column = jCCellRange.start_column;
        }
        return n3;
    }

    int find(int n, int n2, JCCellRange jCCellRange, Dimension dimension) {
        JCCellRange jCCellRange2;
        int n3 = -999;
        int n4 = -999;
        int n5 = 0;
        while (n5 < this.span_list.size()) {
            jCCellRange2 = (JCCellRange)this.span_list.elementAt(n5);
            if (jCCellRange2.inside(n, n2)) {
                if (n == jCCellRange2.start_row && n2 == jCCellRange2.start_column) {
                    n4 = n5;
                    break;
                }
                if (n3 == -999) {
                    n3 = n5;
                }
            }
            ++n5;
        }
        if (n4 == -999) {
            if (n3 != -999) {
                n4 = n3;
            } else {
                return -999;
            }
        }
        jCCellRange2 = (JCCellRange)this.span_list.elementAt(n4);
        if (jCCellRange != null) {
            jCCellRange.reshape(jCCellRange2);
        }
        if (dimension != null) {
            dimension.height = this.table.rowPosition(jCCellRange2.end_row) - this.table.rowPosition(jCCellRange2.start_row) + this.table.rowHeight(jCCellRange2.end_row);
            dimension.width = this.table.columnPosition(jCCellRange2.end_column) - this.table.columnPosition(jCCellRange2.start_column) + this.table.columnWidth(jCCellRange2.end_column);
        }
        return n4;
    }

    JCCellPosition find(int n, int n2) {
        JCCellRange jCCellRange = new JCCellRange();
        if (this.find(n, n2, jCCellRange, null) != -999) {
            return new JCCellPosition(jCCellRange.start_row, jCCellRange.start_column);
        }
        return null;
    }

    boolean isSpanned(int n, int n2) {
        int n3 = 0;
        while (n3 < this.span_list.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.span_list.elementAt(n3);
            if (jCCellRange.inside(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    void adjust() {
        if (this.span_list.size() == 0) {
            return;
        }
        this.adjustWidth();
        this.adjustHeight();
    }

    void copy() {
        this.span_list = new JCVector();
        if (this.span_list_orig.size() == 0) {
            return;
        }
        JCCellRange[] jCCellRangeArray = Clip.get_rangeList(this.table);
        int n = 0;
        while (n < this.span_list_orig.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.span_list_orig.elementAt(n);
            if (jCCellRange.start_row != -999 && jCCellRange.start_column != -999) {
                int n2 = Math.min(jCCellRange.start_row, jCCellRange.end_row);
                int n3 = Math.max(jCCellRange.start_row, jCCellRange.end_row);
                int n4 = Math.min(jCCellRange.start_column, jCCellRange.end_column);
                int n5 = Math.max(jCCellRange.start_column, jCCellRange.end_column);
                if (!Table.isLabel(n2, n4) && !Table.isCell(n2, n4) || !Table.isLabel(n3, n5) && !Table.isCell(n3, n5)) {
                    System.err.println("spanlist.invalidValue: Invalid Range " + jCCellRange);
                } else {
                    int n6 = 0;
                    while (n6 < jCCellRangeArray.length) {
                        if (jCCellRangeArray[n6].inside(n2, n4)) break;
                        ++n6;
                    }
                    if (n6 != jCCellRangeArray.length && this.table.rowHeight(n2) != 0 && this.table.columnWidth(n4) != 0) {
                        jCCellRange = new JCCellRange(n2, n4, n3, n5);
                        JCCellRange jCCellRange2 = jCCellRangeArray[n6].intersection(jCCellRange);
                        jCCellRange.end_row = jCCellRange2.end_row;
                        jCCellRange.end_column = jCCellRange2.end_column;
                        if (!this.isOverlapped(this.span_list, jCCellRange)) {
                            this.span_list.addElement(jCCellRange);
                        }
                    }
                }
            }
            ++n;
        }
        if (this.span_list.size() != this.span_list_orig.size()) {
            this.span_list_orig = (JCVector)this.span_list.clone();
        }
    }

    boolean isOverlapped(JCVector jCVector, JCCellRange jCCellRange) {
        int n = 0;
        int n2 = jCVector.size();
        while (n < n2) {
            JCCellRange jCCellRange2 = (JCCellRange)jCVector.elementAt(n);
            if (jCCellRange.overlaps(jCCellRange2)) {
                System.err.println("spanlist.overlap: Range R" + jCCellRange.start_row + "C" + jCCellRange.start_column + ":R" + jCCellRange.end_row + "C" + jCCellRange.end_column + " overlaps " + "R" + jCCellRange2.start_row + "C" + jCCellRange2.start_column + ":R" + jCCellRange2.end_row + "C" + jCCellRange2.end_column);
                return true;
            }
            ++n;
        }
        return false;
    }

    int spanListSize() {
        return this.span_list.size();
    }

    int origSpanListSize() {
        return this.span_list_orig.size();
    }

    boolean doSpansExist() {
        return this.span_list.size() > 0;
    }

    private void adjustWidth() {
        int n;
        int n2;
        int n3;
        int n4 = 2 * this.table.textWidthOffset();
        int n5 = 0;
        int n6 = 2 * this.table.shadow_thickness + 1;
        boolean bl = false;
        SpanList[] spanListArray = new SpanList[this.span_list.size()];
        int n7 = 0;
        while (n7 < spanListArray.length) {
            spanListArray[n7] = new SpanList();
            ++n7;
        }
        n7 = 0;
        int n8 = 0;
        while (n7 < this.span_list.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.span_list.elementAt(n7);
            spanListArray[n8].start_column = jCCellRange.start_column;
            n3 = spanListArray[n8].start_column;
            spanListArray[n8].end_column = jCCellRange.end_column;
            n2 = spanListArray[n8].end_column;
            if (n3 != n2) {
                n = spanListArray[n8].start_row = jCCellRange.start_row;
                if (this.table.getPixelWidth(n3) == 33001) {
                    Object object = this.table.dataView.getData(n, n3);
                    n5 = JCCell.getWidth(this.table, null, object, n, n3, this.table.getFont(n, n3));
                    if (object instanceof Component) {
                        n5 = n5 - n4 + n6;
                    }
                    spanListArray[n8].width = n5;
                    ++n8;
                }
            }
            ++n7;
        }
        int n9 = -999;
        n7 = 0;
        while (n7 < n8) {
            n3 = spanListArray[n7].start_column;
            n2 = spanListArray[n7].end_column;
            if (n3 != n9) {
                n9 = n3;
                n = spanListArray[n7].start_row;
                int n10 = this.table.columnPosition(n2) - this.table.columnPosition(n3 + 1) + this.table.columnWidth(n2);
                int n11 = spanListArray[n7].width - n10;
                int n12 = 0;
                if (!this.is_span_column_source(-1, n3)) {
                    n12 = JCCell.getWidth(this.table, -1, n3);
                }
                int n13 = 0;
                while (n13 < this.table.rows) {
                    if (!this.is_span_column_source(n13, n3)) {
                        n12 = Math.max(n12, JCCell.getWidth(this.table, n13, n3));
                    }
                    ++n13;
                }
                n11 = Math.max(1, Math.max(n12 + n4, n11 + n4));
                if (Table.isLabel(n, n3) && n11 == 1) {
                    n11 += n4;
                }
                if (n11 != this.table.columnWidth(n3)) {
                    this.table.column_widths.setValue(n3, n3, n11);
                    bl = true;
                }
            }
            ++n7;
        }
        if (bl) {
            Size.getCellTotalWidth(this.table);
        }
    }

    private void adjustHeight() {
        int n;
        int n2;
        int n3;
        int n4 = 2 * this.table.textHeightOffset();
        int n5 = 0;
        int n6 = 2 * this.table.shadow_thickness + 1;
        boolean bl = false;
        SpanList[] spanListArray = new SpanList[this.span_list.size()];
        int n7 = 0;
        while (n7 < spanListArray.length) {
            spanListArray[n7] = new SpanList();
            ++n7;
        }
        n7 = 0;
        int n8 = 0;
        while (n7 < this.span_list.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.span_list.elementAt(n7);
            spanListArray[n8].start_row = jCCellRange.start_row;
            n3 = spanListArray[n8].start_row;
            spanListArray[n8].end_row = jCCellRange.end_row;
            n2 = spanListArray[n8].end_row;
            if (n3 != n2) {
                n = spanListArray[n8].start_column = jCCellRange.start_column;
                if (this.table.getPixelHeight(n3) == 33001) {
                    Object object = this.table.dataView.getData(n3, n);
                    n5 = JCCell.getHeight(this.table, null, object, n3, n, this.table.getFont(n3, n));
                    if (object instanceof Component) {
                        n5 = n5 - n4 + n6;
                    }
                    spanListArray[n8].height = n5;
                    ++n8;
                }
            }
            ++n7;
        }
        int n9 = -999;
        n7 = 0;
        while (n7 < n8) {
            n3 = spanListArray[n7].start_row;
            n2 = spanListArray[n7].end_row;
            if (n3 != n9) {
                n9 = n3;
                n = spanListArray[n7].start_column;
                int n10 = this.table.rowPosition(n2) - this.table.rowPosition(n3 + 1) + this.table.rowHeight(n2);
                int n11 = spanListArray[n7].height - n10;
                int n12 = 0;
                if (!this.is_span_row_source(n3, -1)) {
                    n12 = JCCell.getHeight(this.table, n3, -1);
                }
                int n13 = 0;
                while (n13 < this.table.columns) {
                    if (!this.is_span_row_source(n3, n13)) {
                        n12 = Math.max(n12, JCCell.getHeight(this.table, n3, n13));
                    }
                    ++n13;
                }
                n11 = Math.max(1, Math.max(n12 + n4, n11 + n4));
                if (Table.isLabel(n3, n) && n11 == 1) {
                    n11 += n4;
                }
                if (n11 != this.table.rowHeight(n3)) {
                    this.table.row_heights.setValue(n3, n3, n11);
                    bl = true;
                }
            }
            ++n7;
        }
        if (bl) {
            Size.getCellTotalHeight(this.table);
        }
    }

    private boolean is_span_column_source(int n, int n2) {
        int n3 = 0;
        while (n3 < this.span_list.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.span_list.elementAt(n3);
            if (jCCellRange.start_row == n && jCCellRange.start_column == n2 && jCCellRange.start_column != jCCellRange.end_column) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean is_span_row_source(int n, int n2) {
        int n3 = 0;
        while (n3 < this.span_list.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.span_list.elementAt(n3);
            if (jCCellRange.start_row == n && jCCellRange.start_column == n2 && jCCellRange.start_row != jCCellRange.end_row) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

